#!/bin/sh


################################## helper functions

# $1 - full path to source directory (directory itself not copied)
# $2 - wildcard or file/dir name
function DirectoryRemoveSubset()
{
	echo "DirectoryRemoveSubset [$2] from [$1]"
	find -d "$1" -name "$2" -execdir rm -rf {} \;	#rfv changed to rf 2012.11.18 Support New Uninstaller
#	find "$1" -name '$2' -delete	
}

# $1 - message
# $2 - start time as in `date +%s`
# $3 - end time as in `date +%s`
function ElapsedTimePrint()
{
_elapsed=`expr $3 - $2`
_elapsed_min=`expr $_elapsed / 60`
_elapsed_sec=`expr $_elapsed % 60`

echo "$1 $_elapsed s ($_elapsed_min min $_elapsed_sec s)."
}

function cupsStop()
{
	launchctl unload "/System/Library/LaunchDaemons/org.cups.cupsd.plist"
}

function cupsStart()
{
	launchctl load "/System/Library/LaunchDaemons/org.cups.cupsd.plist"
}

function faxDbStop()
{
	launchctl unload "/Library/LaunchDaemons/com.sec.faxdb.plist"
}

function faxDbStart()
{
	launchctl load "/Library/LaunchDaemons/com.sec.faxdb.plist"
}


# $1 - package name; wildcards allowed
function ReceiptsRemove()
{
groupDir="/Library/Receipts"
DirectoryRemoveSubset "$groupDir" "$1"
if [ $? -ne 0 ]
	then
		printf "error:  !!!  remove /Library/Receipts/$1 failed   !!!\n"
#		exit 1
fi

groupDir="/var/db/receipts"
DirectoryRemoveSubset "$groupDir" "$1"
if [ $? -ne 0 ]
	then
		printf "error:  !!!  remove /var/db/receipts/$1 failed   !!!\n"
#		exit 1
fi
}


################################## main script body


#### set up itself

# set to 1 for debugging
DETAIL_LEVEL=0

# global variables 
MANUFACTURER="Samsung"
PRODUCT="Fax"
FULL_SOFTWARE_PRODUCT_NAME="$MANUFACTURER $PRODUCT"

#### parse parameters

# command line
THIS_SCRIPT_PATH=$0
THIS_SCRIPT_SHORT_NAME=`basename "$THIS_SCRIPT_PATH"`

# echo
# _lastModificationTime=`stat -f "%Sm" "$0"` #`stat -c "%z" "$0"` # `find "$0" -printf "%t"` #
# echo "** SRC Mac Fax Package Maker uninstall procedure of $_lastModificationTime **"
# echo
# echo "PATH:"
# echo $PATH

# check user permissions
MY_UID=`/usr/bin/id -u`
if [ "$MY_UID" != "0" ]
then
	echo
	echo "You should have root privileges in order to install $FULL_SOFTWARE_PRODUCT_NAME."
	echo "Please login as root or use an utility 'su' or 'sudo' when you run $THIS_SCRIPT_PATH." 
	if [ "1" = "$DETAIL_LEVEL" ] ; then
		echo "Current UID: $MY_UID."
	fi		
	exit 2
else
	if [ "1" = "$DETAIL_LEVEL" ] ; then
		echo "root UID: $MY_UID."
	fi		
fi

###### print date
TIME_BEGIN=`date +%s`
echo "Started at `date`"


###### remove the files from directories for different destinations and conditions

echo "CUPS off..."
faxDbStop
### cupsStop


groupDir="/Applications/Samsung"
DirectoryRemoveSubset "$groupDir" "Fax\ Journal.app"
if [ $? -ne 0 ]
	then
		printf "error:  !!!  remove Fax Journal.app failed   !!!\n"
#		exit 1
fi
DirectoryRemoveSubset "$groupDir" "Fax\ Queue\ Creator.app"
if [ $? -ne 0 ]
	then
		printf "error:  !!!  remove Fax Queue Creator.app failed   !!!\n"
#		exit 1
fi


groupDir="/etc/cups"
DirectoryRemoveSubset "$groupDir" "SecPcFax.convs"
if [ $? -ne 0 ]
	then
		printf "error:  !!!  remove CUPS MIME failed   !!!\n"
#		exit 1
fi
DirectoryRemoveSubset "$groupDir" "SecPcFax.types"
if [ $? -ne 0 ]
	then
		printf "error:  !!!  remove CUPS MIME failed   !!!\n"
#		exit 1
fi


groupDir="/Library/Application Support/Samsung"
DirectoryRemoveSubset "$groupDir" "Fax"
if [ $? -ne 0 ]
	then
		printf "error:  !!!  remove Fax failed   !!!\n"
		exit 1
fi


groupDir="/Library/Preferences"
DirectoryRemoveSubset  "$groupDir" "com.src.samsungfax.plist"
if [ $? -ne 0 ]
	then
		printf "error:  !!!  copy com.src.samsungfax.plist failed   !!!\n"
		exit 1
fi

groupDir="/Library/LaunchDaemons"
DirectoryRemoveSubset  "$groupDir" "com.sec.faxdb.plist"
if [ $? -ne 0 ]
	then
		printf "error:  !!!  copy com.sec. faxdb.plist failed   !!!\n"
		exit 1
fi


groupDir="/Library/Printers/Samsung"
DirectoryRemoveSubset  "$groupDir" "Fax"
if [ $? -ne 0 ]
	then
		printf "error:  !!!  $groupDir remove failed   !!!\n"
#		exit 1
fi


groupDir="/usr/libexec/cups"

backendDir=$groupDir/backend
DirectoryRemoveSubset "$backendDir" "samsungfax"
if [ $? -ne 0 ]
	then
		printf "error:  !!!  remove samsungfax failed   !!!\n"
#		exit 1
fi

filterDir=$groupDir/filter
DirectoryRemoveSubset "$filterDir" "tiff2backend"
if [ $? -ne 0 ]
	then
		printf "error:  !!!  remove tiff2backend failed   !!!\n"
#		exit 1
fi


groupDir="/Library/Printers/PPDs/Contents/Resources"
DirectoryRemoveSubset "$groupDir" "Samsung\ FAX\ printer.*"
if [ $? -ne 0 ]
	then
		printf "error:  !!!  remove Samsung FAX printer.* failed   !!!\n"
#		exit 1
fi



###### remove PackageMaker stuff files
ReceiptsRemove "com.src.fax.samsungFax.*"
ReceiptsRemove "com.src.fax.macfaxfiles.pkg.bom"
ReceiptsRemove "com.src.fax.macfaxfiles.pkg.plist"

ReceiptsRemove "applicationsfax.*"
ReceiptsRemove "etccups.*"
ReceiptsRemove "libappsupportfax.*"
ReceiptsRemove "liblaunchdaemons.*"
ReceiptsRemove "libpreferences.*"
ReceiptsRemove "libprintppdx5.*"
ReceiptsRemove "libprintppdx4.*"
ReceiptsRemove "libprintfax.*"
ReceiptsRemove "usrlibexeccups.*"


echo "CUPS on..."
### cupsStart

groupDir="/Library/Application Support/Samsung/Uninstaller/Common"
DirectoryRemoveSubset  "$groupDir" "Fax.sh"
rmdir "$groupDir"
groupDir="/Library/Application Support/Samsung/Uninstaller"
rmdir "$groupDir"

groupDir="/Library/Application Support/Samsung"
rmdir "$groupDir"

###### print date
TIME_END=`date +%s`
echo
ElapsedTimePrint "$FULL_SOFTWARE_PRODUCT_NAME Uninstall - Total uninstall time:" $TIME_BEGIN $TIME_END

